[//lasso
	// Twitter API for Lasso
	// (c)2007 Jason Huck/Core Five Creative
	// requires: JSON library, string_truncate, date_toHTTP (below)

	define_tag(
		'toHTTP',
		-namespace='date_',
		-req='in', -type='date',
		-priority='replace',
		-encodenone,
		-description='HTTP-formats the given date.'
	);
		local('out') = null;
		!#in->gmt ? #in = date_localtogmt(#in);
		#in->setformat('%Q %T');
		#out = encode_url(string(#in))->replace('%20','+')&;
		return(#out);	
	/define_tag;


	define_type(
		'twitter',
		-description='Implements the Twitter API in Lasso.'
	);
		local(
			'username' = string,
			'password' = string
		);
		
		define_tag(
			'oncreate',
			-opt='username', -type='string',
			-opt='password', -type='string'
		);
			local_defined('username') ? self->username = #username;
			local_defined('password') ? self->password = #password;
		/define_tag;
	
		define_tag('authcheck');
			return(self->username != '' && self->password != '');
		/define_tag;
		
		define_tag(
			'retrieve', 
			-req='path', -type='string',
			-opt='post', -type='array',
			-encodenone
		);
			fail_if(!self->authcheck, -1, 'Username or password not set.');
			
			protect;
				local('response') = string(
					local_defined('post') ? include_url(
						'http://twitter.com' + #path,
						-username=self->username,
						-password=self->password,
						-postparams=#post,
						-timeout=15
					) | include_url(
						'http://twitter.com' + #path,
						-username=self->username,
						-password=self->password,
						-timeout=15
					)
				);
				
				handle_error;
					local('response') = 'There was a problem communicating with Twitter.';
				/handle_error;
			/protect;
			
			return(decode_json(#response));
		/define_tag;
		
		define_tag(
			'public_timeline',
			-opt='since_id', -type='integer',
			-encodenone
		);
			local('path') = '/statuses/public_timeline.json' + (local_defined('since_id') ? '?since_id=' + #since_id);
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'friends_timeline',
			-opt='id',
			-opt='since', -type='date',
			-opt='page', -type='integer',
			-encodenone
		);
			local('path') = '/statuses/friends_timeline' + (local_defined('id') ? '/' + #id) + '.json';
			local_defined('since') || local_defined('page') ? #path += '?';
			local_defined('since') ? #path += 'since=' + date_toHTTP(#since);
			local_defined('page') ? #path += (!#path->endswith('?') ? '&') + 'page=' + #page;
			return(self->retrieve(#path));			
		/define_tag;
		
		define_tag(
			'user_timeline',
			-opt='id',
			-opt='count', -type='integer',
			-opt='since', -type='date',
			-encodenone
		);
			local('path') = '/statuses/user_timeline' + (local_defined('id') ? '/' + #id) + '.json';
			local_defined('count') || local_defined('since') ? #path += '?';
			local_defined('count') ? #path += 'count=' + #count;
			local_defined('since') ? #path += (!#path->endswith('?') ? '&') + 'since=' + date_toHTTP(#since);
			return(self->retrieve(#path));			
		/define_tag;
		
		define_tag(
			'show_status',
			-req='id', -type='integer',
			-encodenone
		);
			local('path') = '/statuses/show/' + #id + '.json';
			return(self->retrieve(#path));			
		/define_tag;
		
		define_tag(
			'update',
			-req='status', -type='string',
			-encodenone
		);
			local('path') = '/statuses/update.json';
			local('post') = array('status' = string_truncate(#status, 160));
			return(self->retrieve(#path, #post));			
		/define_tag;
		
		define_tag(
			'replies',
			-opt='page', -type='integer',
			-encodenone
		);
			local('path') = '/statuses/replies.json';
			local_defined('page') ? #path += '?page=' + #page;
			return(self->retrieve(#path));			
		/define_tag;
		
		define_tag(
			'destroy_status',
			-req='id', -type='integer',
			-encodenone
		);
			local('path') = '/statuses/destroy/' + #id + '.json';
			return(self->retrieve(#path));			
		/define_tag;
		
		define_tag(
			'friends',
			-opt='id',
			-encodenone
		);
			local('path') = '/statuses/friends' + (local_defined('id') ? '/' + #id) + '.json';
			return(self->retrieve(#path));			
		/define_tag;
		
		define_tag(
			'followers',
			-opt='lite', -type='boolean',
			-encodenone
		);
			local('path') = '/statuses/followers.json';
			local_defined('lite') && #lite ? #path += '?lite=true';
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag('featured');
			local('path') = '/statuses/featured.json';
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag( // not working
			'show_user',
			-opt='id',
			-opt='email', -type='string',
			-encodenone
		);
			local_defined('id') ? local('path') = '/users/show/' + #id + '.json';
			local_defined('email') ? local('path') = '/users/show.json?email=' + #email;
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'direct_messages',
			-opt='since', -type='date',
			-opt='since_id', -type='integer',
			-opt='page', -type='integer',
			-encodenone
		);
			local('path') = '/direct_messages.json';
			params->size ? #path += '?';
			local_defined('since') ? #path += 'since=' + date_toHTTP(#since) + '&';
			local_defined('since_id') ? #path += 'since_id=' + #since_id + '&';
			local_defined('page') ? #path += 'page=' + #page;
			#path->removetrailing('&');
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'sent_direct',
			-opt='since', -type='date',
			-opt='since_id', -type='integer',
			-opt='page', -type='integer',
			-encodenone
		);
			local('path') = '/direct_messages/sent.json';
			params->size ? #path += '?';
			local_defined('since') ? #path += 'since=' + date_toHTTP(#since) + '&';
			local_defined('since_id') ? #path += 'since_id=' + #since_id + '&';
			local_defined('page') ? #path += 'page=' + #page;
			#path->removetrailing('&');
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'new_direct',
			-req='user',
			-req='text', -type='string',
			-encodenone
		);
			local('path') = '/direct_messages/new.json';
			local('post') = array(
				'user' = #user,
				'text' = string_truncate(#text, -length=140)
			);
			
			return(self->retrieve(#path, #post));
		/define_tag;
		
		define_tag(
			'destroy_direct',
			-req='id', -type='integer',
			-encodenone
		);
			local('path') = '/direct_messages/destroy/' + #id + '.json';
			return(self->retrieve(#path));
		/define_tag;

		define_tag(
			'create_friendship',
			-req='id',
			-encodenone
		);
			local('path') = '/friendships/create/' + #id + '.json';
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'destroy_friendship',
			-req='id',
			-encodenone
		);
			local('path') = '/friendships/destroy/' + #id + '.json';
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'verify_credentials',
			-encodenone
		);
			local('path') = '/account/verify_credentials.json';
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'end_session',
			-encodenone
		);
			local('path') = '/account/end_session';
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'archive',
			-opt='page', -type='integer',
			-encodenone
		);
			local('path') = '/account/archive.json';
			local_defined('page') ? #path += '?page=' + #page;
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'favorites',
			-opt='id',
			-opt='page', -type='integer',
			-encodenone
		);
			local('path') = '/favourings' + (local_defined('id') ? '/' + #id) + '.json';
			local_defined('page') ? #path += '?page=' + #page;
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'create_favorite',
			-req='id', -type='integer',
			-encodenone
		);
			local('path') = '/favourings/create/' + #id + '.json';
			return(self->retrieve(#path));
		/define_tag;
		
		define_tag(
			'destroy_favorite',
			-req='id', -type='integer',
			-encodenone
		);
			local('path') = '/favourings/destroy/' + #id + '.json';
			return(self->retrieve(#path));
		/define_tag;
	/define_type;



	/* SVN: $Id: twitter.inc 558 2008-01-05 00:45:30Z Jason Huck $ */
]
